EvaluateScript("enemy.js");
EvaluateScript("battle2.js");

images.bCommandSmall = LoadImage("BCommand-Small.png");
images.bCommandExpand = LoadImage("BCommand-Expand.png");

function StartBattle(battle, background, music)
{
	battle.reset();
	if (music == undefined)
	{
		music = battles.music;
	}
	battle.music = music;
	battle.background = LoadImage(background);
	switch (Game.party.length)
	{
		case 1:
			Game.party[0].x = 79;
			Game.party[0].oX = 79;
			Game.party[0].y = 167;
			Game.party[0].oY = 167;
			break;
	}
	battle.party = Game.party.reverse();
	Game.battle = battle;
	battle.engine();
}

function Battle()
{
	this.exp = 0;
	this.coins = 0;
	this.ap = 0;
	this.enemy = new Array();
	this.animating = false;
	this.updating = false;
	this.fighting = true;
	this.winner = "";
}

Battle.prototype.reset = function()
{
	for (var i = 0; i < this.enemy.length; i ++)
	{
		this.enemy[i].reset();
	}
}

Battle.prototype.addEnemy = function(enemy, x, y)
{
	var num = this.enemy.length;
	this.enemy[num] = enemy.clone();
	this.enemy[num].x = x;
	this.enemy[num].y = y;
}

Battle.prototype.engine = function()
{
	//this.music.play(true);
	while (this.fighting)
	{
		this.draw();
		FlipScreen();
		if (!this.animating)
		{
			this.update();
			switch (this.testDeath())
			{
				case "Enemy":
					this.fighting = false;
					this.winner = "Party";
					break;
				case "Party":
					this.fighting = false;
					this.winner = "Enemy";
					break;
				default:
					break;
			}
		}
	}
	if (this.winner == "Party")
	{
	}
	else if (this.winner == "Enemy")
	{
		var gameover = LoadImage("Game Over.png");
		while (!IsKeyPressed(KEY_SPACE))
		{
			gameover.blit(0, 0);
			FlipScreen();
		}
	}
}

Battle.prototype.draw = function()
{
	this.background.blit(0, 0);
	// Draw enemies
	for (var i = 0; i < this.enemy.length; i ++)
	{
		this.enemy[i].draw(undefined, undefined, this.enemy[i].situation, this.enemy[i].aFreeze);
	}
	// Draw characters
	for (var i = 0; i < Game.pSize; i ++)
	{
		Game.party[i].draw(undefined, undefined, Game.party[i].situation, Game.party[i].aFreeze);
	}
	// Draw damage
	// Draw window
	for (var i = 0; i < Game.pSize; i ++)
	{
		battleWindow(56 - i * 29, 14 + i * 26, this.party[i]);
	}
	font.drawText(0, 0, this.exp);
	font.drawText(0, 10, this.coins);
}

Battle.prototype.update = function()
{
	var whom = getTurn();
	if (whom != false)
	{
		whom.turn();
	}
	else
	{
		for (var i = 0; i < Game.pSize; i ++)
		{
			Game.party[i].act = false;
		}
		for (var i = 0; i < this.enemy.length; i ++)
		{
			this.enemy[i].act = false;
		}
	}
}

Battle.prototype.testDeath = function()
{
	var pDead = 0;
	for (var i = 0; i < Game.pSize; i ++)
	{
		if (Unavailable(Game.party[i]))
		{
			pDead ++;
		}
	}
	var eDead = 0;
	for (var i = 0; i < this.enemy.length; i ++)
	{
		if (Unavailable(this.enemy[i]))
		{
			eDead ++;
		}
	}
	if (pDead == Game.pSize)
	{
		return "Party";
	}
	else if (eDead == this.enemy.length)
	{
		return "Enemy";
	}
	else
		return false;
}

function Damage(target, amount)
{
	if (target.hp - amount < 0)
	{
		return target.hp;
	}
	else
		return amount;
}

var battles = new Object();
battles.music = LoadSound("fight.it");
battles.test = new Battle();
battles.test.addEnemy(enemies.terrapin, 200, 100);
battles.test.addEnemy(enemies.terrapin, 160, 80);